// AnalogDeviceVideoGraph.cpp: implementation of the CAnalogDeviceVideoGraph class.
//
//////////////////////////////////////////////////////////////////////

#include "stdafx.h"
#include "AnalogDeviceVideoGraph.h"

#ifdef _DEBUG
#undef THIS_FILE
static char THIS_FILE[]=__FILE__;
#define new DEBUG_NEW
#endif

static const GUID PROPSETID_AMEBDAD_CUSTOM_PROP = { 0xD1E5209F, 0x68FD, 0x4529, 0xBE, 0xE0, 0x5E, 0x7A, 0x1F, 0x47, 0x92, 0x00 }; // CUSTOM PROPERITY { D1E5209F-68FD-4529-BEE0-5E7A1F4792XX }

//////////////////////////////////////////////////////////////////////
// Construction/Destruction
//////////////////////////////////////////////////////////////////////

VOID CAnalogDeviceVideoGraph::SC_DEBUG( CHAR * fmt, ... )
{
	CHAR pszDebugDumpMessage[ MAX_PATH ] = "[SC510] [00000000] ";

	va_list marker;

	va_start( marker, fmt );

	StringCbPrintfA( pszDebugDumpMessage + 8, sizeof(pszDebugDumpMessage), "[%08X] ", this );

	StringCbVPrintfA( pszDebugDumpMessage + 8 + 1 + 10, sizeof(pszDebugDumpMessage), fmt, marker );

	va_end( marker );

	StringCbCatA( pszDebugDumpMessage, sizeof(pszDebugDumpMessage), "\n" );

	OutputDebugString( pszDebugDumpMessage );
}

CAnalogDeviceVideoGraph::CAnalogDeviceVideoGraph()
{
//	SC_DEBUG( "CAnalogDeviceVideoGraph::CAnalogDeviceVideoGraph()" );

	m_pCaptureSourceBaseFilter = NULL;

	m_pSampleGrabberBaseFilter = NULL;

	m_pSmartTeeBaseFilter = NULL;

	m_pColorConverterBaseFilter = NULL;

	m_pVideoNullRendererBaseFilter = NULL;

	m_pKsPropertySet = NULL;

	m_sKsPropertySetGUID = GUID_NULL;

	m_pAMAnalogVideoDecoder = NULL;

	m_pAMStreamConfig = NULL;

	m_pSampleGrabber = NULL;

	m_oSampleGrabber.SetCallback( NULL, NULL );

	m_pVideoWindow = NULL;

	m_hAttachWindow = NULL;

	m_nColorSpaceType = 0x00000000;

	m_nWidth = 0;

	m_nHeight = 0;

	m_nBitCount = 0;

	m_dFrameRate = 0.0;
}

CAnalogDeviceVideoGraph::~CAnalogDeviceVideoGraph()
{
//	SC_DEBUG( "CAnalogDeviceVideoGraph::~CAnalogDeviceVideoGraph()" );

	CAnalogDeviceVideoGraph::Close( FALSE );
}

BOOL CAnalogDeviceVideoGraph::Close( BOOL bDumpDebugMessage )
{
	if( bDumpDebugMessage ) { SC_DEBUG( "CAnalogDeviceVideoGraph::Close()" ); }

	if( m_pCommonMediaControl ) { if( GetState() == State_Running ) { Stop(); } }

	if( m_pCommonMediaControl ) { if( GetState() == State_Paused ) { Stop(); } }

	m_oSampleGrabber.SetCallback( NULL, NULL );

	RELEASE( m_pVideoWindow );

	RELEASE( m_pSampleGrabber );	

	RELEASE( m_pKsPropertySet );

	RELEASE( m_pAMAnalogVideoDecoder );

	RELEASE( m_pAMStreamConfig );

	RELEASE( m_pVideoNullRendererBaseFilter );

	RELEASE( m_pColorConverterBaseFilter );

	RELEASE( m_pSmartTeeBaseFilter );

	RELEASE( m_pSampleGrabberBaseFilter );

	RELEASE( m_pCaptureSourceBaseFilter );

	m_sKsPropertySetGUID = GUID_NULL;

	m_hAttachWindow = NULL;

	m_nColorSpaceType = 0x00000000;

	m_nWidth = 0;

	m_nHeight = 0;

	m_nBitCount = 0;

	m_dFrameRate = 0.0;

	return CloseGraphBuilder( bDumpDebugMessage );
}

BOOL CAnalogDeviceVideoGraph::Create( PWSTR              pwszDevName, 
									 
									  UINT               iDevNum, 

									  PF_BUFFER_CALLBACK pBufferCB, 

									  PVOID              pUserData, 

									  HWND               hAttachWindow )
{
	WCHAR pwszFilterNameBuffer[ 256 ];

	StringCchPrintfW( pwszFilterNameBuffer, 256, L"%ws, Analog Capture (#%02d)", pwszDevName, iDevNum + 1 );

	m_hAttachWindow = hAttachWindow;

	// CREATE GRAPH BUILDER RESOURCE
	//
	if( FALSE == CreateGraphBuilder() ) return FALSE; 

	// FIND/ADD CAPTURE SOURCE FILTER INTO GRAPH
	//
	if( FALSE == FindFilter( &CLSID_VideoInputDeviceCategory, pwszFilterNameBuffer, 0, &m_pCaptureSourceBaseFilter, pwszFilterNameBuffer, 256 ) )
	{
		StringCchPrintfW( pwszFilterNameBuffer, 256, L"%ws, Analog %02d Capture", pwszDevName, iDevNum + 1 );

		if( FALSE == FindFilter( &CLSID_VideoInputDeviceCategory, pwszFilterNameBuffer, 0, &m_pCaptureSourceBaseFilter, pwszFilterNameBuffer, 256 ) ) {
	
			return FALSE;
		}
	}
	
	if( FALSE == AddFilter( m_pCaptureSourceBaseFilter, pwszFilterNameBuffer ) ) return FALSE;

	// FIND/ADD SAMPLE GRABBER FILTER INTO GRAPH
	//
	if( FAILED(CoCreateInstance( CLSID_SampleGrabber, NULL, CLSCTX_INPROC_SERVER, IID_IBaseFilter, (VOID **)(&m_pSampleGrabberBaseFilter) )) ) { SC_DEBUG( "CAnalogDeviceVideoGraph::Create( CoCreateInstance(CLSID_SampleGrabber) ) ERROR!!" ); return FALSE; }

	if( FALSE == AddFilter( m_pSampleGrabberBaseFilter, L"Sample Grabber" ) ) return FALSE;

	// FIND/ADD DISPLAY-RELATED FILTERS INTO GRAPH
	//
	if( FALSE == FindFilter( &CLSID_LegacyAmFilterCategory, L"Smart Tee", 0, &m_pSmartTeeBaseFilter, pwszFilterNameBuffer, 256 ) ) return FALSE;
	
	if( FALSE == AddFilter( m_pSmartTeeBaseFilter, pwszFilterNameBuffer ) ) return FALSE;

	if( FALSE == FindFilter( &CLSID_LegacyAmFilterCategory, L"Custom Color Converter Filter", 0, &m_pColorConverterBaseFilter, pwszFilterNameBuffer, 256 ) ) return FALSE;
	
	if( FALSE == AddFilter( m_pColorConverterBaseFilter, pwszFilterNameBuffer ) ) return FALSE;

	if( FAILED(CoCreateInstance( CLSID_VideoRendererDefault, NULL, CLSCTX_INPROC_SERVER, IID_IBaseFilter, (VOID **)(&m_pVideoNullRendererBaseFilter) )) ) { SC_DEBUG( "CAnalogDeviceVideoGraph::Create( CoCreateInstance(CLSID_VideoRendererDefault) ) ERROR!!" ); return FALSE; }

	if( FALSE == AddFilter( m_pVideoNullRendererBaseFilter, L"Video Renderer" ) ) return FALSE;

	// OBTAIN PROPERTY INTERFACE FROM FILTER
	//
	if( SUCCEEDED(m_pCommonCaptureGraphBuilder2->FindInterface(                  NULL, NULL,     m_pCaptureSourceBaseFilter, IID_IKsPropertySet,        (VOID **)(&m_pKsPropertySet)        )) ) { SC_DEBUG( "CAnalogDeviceVideoGraph::Create( FindInterface(IID_IKsPropertySet) )" ); }

	if( SUCCEEDED(m_pCommonCaptureGraphBuilder2->FindInterface(                  NULL, NULL,     m_pCaptureSourceBaseFilter, IID_IAMAnalogVideoDecoder, (VOID **)(&m_pAMAnalogVideoDecoder) )) ) { SC_DEBUG( "CAnalogDeviceVideoGraph::Create( FindInterface(IID_IAMAnalogVideoDecoder) )" ); }

	if( SUCCEEDED(m_pCommonCaptureGraphBuilder2->FindInterface( &LOOK_DOWNSTREAM_ONLY, NULL,     m_pCaptureSourceBaseFilter, IID_IAMStreamConfig,       (VOID **)(&m_pAMStreamConfig)       )) ) { SC_DEBUG( "CAnalogDeviceVideoGraph::Create( FindInterface(IID_IAMStreamConfig) )" ); }

	if( SUCCEEDED(m_pCommonCaptureGraphBuilder2->FindInterface(                  NULL, NULL,     m_pSampleGrabberBaseFilter, IID_ISampleGrabber,        (VOID **)(&m_pSampleGrabber)        )) ) { SC_DEBUG( "CAnalogDeviceVideoGraph::Create( FindInterface(IID_ISampleGrabber) )" ); }

	if( SUCCEEDED(m_pCommonCaptureGraphBuilder2->FindInterface(                  NULL, NULL, m_pVideoNullRendererBaseFilter, IID_IVideoWindow,          (VOID **)(&m_pVideoWindow)          )) ) { SC_DEBUG( "CAnalogDeviceVideoGraph::Create( FindInterface(IID_IVideoWindow) )" ); }

	if( NULL != m_pSampleGrabber ) {

		if( FAILED(m_pSampleGrabber->SetOneShot( FALSE )) ) { SC_DEBUG( "CAnalogDeviceVideoGraph::Create( ISampleGrabber::SetOneShot() ) ERROR!!" ); return FALSE; }

		if( FAILED(m_pSampleGrabber->SetBufferSamples( FALSE )) ) { SC_DEBUG( "CAnalogDeviceVideoGraph::Create( ISampleGrabber::SetBufferSamples() ) ERROR!!" ); return FALSE; }

		if( FAILED(m_pSampleGrabber->SetCallback( &m_oSampleGrabber, 0 )) ) { SC_DEBUG( "CAnalogDeviceVideoGraph::Create( ISampleGrabber::SetCallback() ) ERROR!!" ); return FALSE; }

		m_oSampleGrabber.SetCallback( pBufferCB, pUserData );

		m_oSampleGrabber.SetDeviceType( 0x00000000 );
	}

	// ENUM / FIND OUT DEVICE'S CUSTOM PROPERTY GUID (0x00 ~ 0xFF)
	// 
	if( NULL != m_pKsPropertySet ) { 

		GUID guid = PROPSETID_AMEBDAD_CUSTOM_PROP;

		for( ULONG i = 0 ; i < 36 ; i++ ) { 
		
			DWORD dwDeviceSerialNumber = 0x00000000;

			DWORD cbBytes = 0x00000000;

			guid.Data4[ 7 ] = (BYTE)(i);

			if( SUCCEEDED(m_pKsPropertySet->Get( guid, 0, NULL, 0, &dwDeviceSerialNumber, sizeof(ULONG), &cbBytes )) ) { 
				
				SC_DEBUG( "CAnalogDeviceVideoGraph::Create( IKsPropertySet::GetDeviceSerialNumber( 0x%08X ) )", dwDeviceSerialNumber );

				m_sKsPropertySetGUID = guid;

				break; 
			}
		}
	}

	// SET DEFAULT STANDARD / FORMAT
	// 
	ULONG nStandard = 0x000000000;
	
	if( FALSE == GetStandard( &nStandard ) ) return FALSE;

	if( FALSE == GetFormat( &m_nColorSpaceType, &m_nWidth, &m_nHeight, &m_nBitCount, &m_dFrameRate ) ) return FALSE;

	if( FALSE == SetFormat( m_nColorSpaceType, m_nWidth, m_nHeight, m_nBitCount, m_dFrameRate ) ) return FALSE;

	// COMPLETE
	//
	SC_DEBUG( "CAnalogDeviceVideoGraph::Create()" );

	return TRUE;
}

BOOL CAnalogDeviceVideoGraph::GetFormat( ULONG *  pColorSpaceType,
										
										 ULONG *  pWidth,
										 
										 ULONG *  pHeight,
										 
										 ULONG *  pBitCount,
										 
										 double * pFrameRate )
{
	AM_MEDIA_TYPE * pmt = NULL;

	if( NULL == m_pAMStreamConfig ) { SC_DEBUG( "CAnalogDeviceVideoGraph::GetFormat( NULL ) ERROR!!" ); return FALSE; }

	if( FAILED(m_pAMStreamConfig->GetFormat( &pmt )) ) { SC_DEBUG( "CAnalogDeviceVideoGraph::GetFormat( IAMStreamConfig::GetFormat() ) ERROR!!" ); return FALSE; }

	ULONG  cso = ((VIDEOINFOHEADER *)(pmt->pbFormat))->bmiHeader.biCompression;

	ULONG  cxo = ((VIDEOINFOHEADER *)(pmt->pbFormat))->bmiHeader.biWidth;

	ULONG  cyo = ((VIDEOINFOHEADER *)(pmt->pbFormat))->bmiHeader.biHeight;

	ULONG  czo = ((VIDEOINFOHEADER *)(pmt->pbFormat))->bmiHeader.biBitCount;

	double fps = (double)(10000000.0 / ((VIDEOINFOHEADER *)(pmt->pbFormat))->AvgTimePerFrame);

	if( pColorSpaceType ) { *pColorSpaceType = cso; }

	if( pWidth ) { *pWidth = cxo; }

	if( pHeight ) { *pHeight = cyo; }

	if( pBitCount ) { *pBitCount = czo; }

	if( pFrameRate ) { *pFrameRate = fps; }

	SC_DEBUG( "CAnalogDeviceVideoGraph::GetFormat( %08X  %d  %d  %d  %2.6f )", cso, cxo, cyo, czo, fps );

	DeleteMediaType( pmt );

	pmt = NULL;

	return TRUE;
}

BOOL CAnalogDeviceVideoGraph::SetFormat( ULONG  nColorSpaceType,
										 
										 ULONG  nWidth,

										 ULONG  nHeight,
										 
										 ULONG  nBitCount,
										 
										 double dFrameRate )
{
	ULONG           nStandard = 0x00000000;

	OAFilterState   eState = GetState();

	AM_MEDIA_TYPE * pmt = NULL;

	GUID			guid = { 0x00000000, 0x0000, 0x0010, 0x80, 0x00, 0x00, 0xAA, 0x00, 0x38, 0x9B, 0x71 };

	ULONG			i = 0;

	if( FALSE == Stop() ) { return FALSE; }

	if( FALSE == GetStandard( &nStandard ) ) { return FALSE; }

	if( NULL == m_pAMStreamConfig ) { SC_DEBUG( "CAnalogDeviceVideoGraph::SetFormat( NULL ) ERROR!!" ); return FALSE; }

	if( FAILED(m_pAMStreamConfig->GetFormat( &pmt )) ) { SC_DEBUG( "CAnalogDeviceVideoGraph::SetFormat( IAMStreamConfig::GetFormat() ) ERROR!!" ); return FALSE; }

	if( nStandard & SUPPORTED_ANALOG_VIDEO_STANDARDS_50HZ ) {

		if( dFrameRate == 24.000000 ) { dFrameRate = 25.000000; }

		if( dFrameRate == 29.970000 ) { dFrameRate = 25.000000; }

		if( dFrameRate == 30.000000 ) { dFrameRate = 25.000000; }

		if( dFrameRate == 59.940000 ) { dFrameRate = 50.000000; }

		if( dFrameRate == 60.000000 ) { dFrameRate = 50.000000; }

		if( nHeight    ==       480 ) { nHeight    =       576; }

		if( nHeight    ==       240 ) { nHeight    =       288; }

		if( nHeight    ==       120 ) { nHeight    =       144; }
	}
	if( nStandard & SUPPORTED_ANALOG_VIDEO_STANDARDS_60HZ ) {

		if( dFrameRate == 24.000000 ) { dFrameRate = 29.970000; }

		if( dFrameRate == 25.000000 ) { dFrameRate = 29.970000; }

		if( dFrameRate == 30.000000 ) { dFrameRate = 29.970000; }

		if( dFrameRate == 50.000000 ) { dFrameRate = 59.940000; }

		if( dFrameRate == 60.000000 ) { dFrameRate = 59.940000; }

		if( nHeight    ==       576 ) { nHeight    =       480; }

		if( nHeight    ==       288 ) { nHeight    =       240; }

		if( nHeight    ==       144 ) { nHeight    =       120; }
	}
	((VIDEOINFOHEADER *)(pmt->pbFormat))->bmiHeader.biCompression = guid.Data1 = nColorSpaceType;

	((VIDEOINFOHEADER *)(pmt->pbFormat))->bmiHeader.biHeight = nHeight;

	((VIDEOINFOHEADER *)(pmt->pbFormat))->bmiHeader.biWidth = nWidth;

	((VIDEOINFOHEADER *)(pmt->pbFormat))->bmiHeader.biBitCount = (USHORT)(nBitCount);

	((VIDEOINFOHEADER *)(pmt->pbFormat))->bmiHeader.biSizeImage = nWidth * nHeight * nBitCount / 8;

	((VIDEOINFOHEADER *)(pmt->pbFormat))->AvgTimePerFrame = (ULONG)(INT)(10000000.0 / dFrameRate);

	((VIDEOINFOHEADER *)(pmt->pbFormat))->dwBitRate = (ULONG)(INT)(nWidth * nHeight * nBitCount * dFrameRate * 8);

	pmt->subtype = guid;

	// DISCONNECT FILTERS
	//
	if( FALSE == DisconnectFilters( m_pCaptureSourceBaseFilter, m_pSampleGrabberBaseFilter ) ) { ; }

	if( FALSE == DisconnectFilters( m_pSampleGrabberBaseFilter, m_pSmartTeeBaseFilter ) ) { ; }

	if( FALSE == DisconnectFilters( m_pSmartTeeBaseFilter, m_pColorConverterBaseFilter ) ) { ; }

	if( FALSE == DisconnectFilters( m_pColorConverterBaseFilter, m_pVideoNullRendererBaseFilter ) ) { ; }

	// RESET COLOR CONVERTER FILTERE
	//
	if( m_pColorConverterBaseFilter ) {

		RemoveFilter( m_pColorConverterBaseFilter );

		RELEASE( m_pColorConverterBaseFilter );

		WCHAR pwszFilterNameBuffer[ 256 ];

		if( FALSE == FindFilter( &CLSID_LegacyAmFilterCategory, L"Custom Color Converter Filter", 0, &m_pColorConverterBaseFilter, pwszFilterNameBuffer, 256 ) ) { goto EXIT_SETFORMAT; }

		if( FALSE == AddFilter( m_pColorConverterBaseFilter, pwszFilterNameBuffer ) ) goto EXIT_SETFORMAT;
	}

	// CHANGE FORMAT
	//
	if( FAILED(m_pAMStreamConfig->SetFormat( pmt )) ) { 
		
		SC_DEBUG( "CAnalogDeviceVideoGraph::SetFormat( IAMStreamConfig::SetFormat() ) ERROR!!" );
		
		goto EXIT_SETFORMAT;
	}

	// CONNECT FILTERS
	//
	if( FALSE == ConnectFilters( m_pCaptureSourceBaseFilter, m_pSampleGrabberBaseFilter ) ) goto EXIT_SETFORMAT;

	if( FALSE == ConnectFilters( m_pSampleGrabberBaseFilter, m_pSmartTeeBaseFilter ) ) goto EXIT_SETFORMAT;

	if( FALSE == ConnectFilters( m_pSmartTeeBaseFilter, m_pColorConverterBaseFilter, 1 ) ) goto EXIT_SETFORMAT;

	if( FALSE == ConnectFilters( m_pColorConverterBaseFilter, m_pVideoNullRendererBaseFilter ) ) goto EXIT_SETFORMAT;
	
	// ATTACH WINDOW
	//
	if( FAILED(m_pVideoWindow->put_Owner( (OAHWND)(m_hAttachWindow) )) ) { SC_DEBUG( "CAnalogDeviceVideoGraph::SetFormat( IVideoWindow::put_Owner() ) ERROR!!" ); goto EXIT_SETFORMAT; }

	if( FAILED(m_pVideoWindow->put_WindowStyle( (WS_CHILD) )) ) { SC_DEBUG( "CAnalogDeviceVideoGraph::SetFormat( IVideoWindow::put_WindowStyle() ) ERROR!!" ); goto EXIT_SETFORMAT; }

	if( FAILED(m_pVideoWindow->put_MessageDrain( (OAHWND)(m_hAttachWindow) )) ) { SC_DEBUG( "CAnalogDeviceVideoGraph::SetFormat( IVideoWindow::put_MessageDrain() ) ERROR!!" ); goto EXIT_SETFORMAT; }

	if( FALSE == RefreshDisplayWindow() ) goto EXIT_SETFORMAT;

	// FINISH
	//
	SC_DEBUG( "CAnalogDeviceVideoGraph::SetFormat( %08X  %d  %d  %d  %2.6f )", nColorSpaceType, nWidth, nHeight, nBitCount, dFrameRate );

	DeleteMediaType( pmt );

	pmt = NULL;

	if( FALSE == GetFormat( NULL, NULL, NULL, NULL, NULL ) ) { return FALSE; }

	if( eState == State_Running ) { // RESUME

		return Run();
	}
	return TRUE;

EXIT_SETFORMAT:

	DeleteMediaType( pmt );

	pmt = NULL;

	return FALSE;
}

BOOL CAnalogDeviceVideoGraph::GetStandard( ULONG * pStandard )
{
	if( NULL == pStandard ) { SC_DEBUG( "CAnalogDeviceVideoGraph::GetStandard( NULL ) ERROR!!" ); return FALSE; }

	if( NULL == m_pAMAnalogVideoDecoder ) { SC_DEBUG( "CAnalogDeviceVideoGraph::GetStandard( NULL ) ERROR!!" ); return FALSE; }

	if( FAILED(m_pAMAnalogVideoDecoder->get_TVFormat( (LONG *)(pStandard) )) ) { SC_DEBUG( "CAnalogDeviceVideoGraph::GetStandard( IAMAnalogVideoDecoder::get_TVFormat() ) ERROR!!" ); return FALSE; }

	SC_DEBUG( "CAnalogDeviceVideoGraph::GetStandard( %08X )", *pStandard );

	return TRUE;
}

BOOL CAnalogDeviceVideoGraph::SetStandard( ULONG nStandard )
{
	if( NULL == m_pAMAnalogVideoDecoder ) { SC_DEBUG( "CAnalogDeviceVideoGraph::SetStandard( NULL ) ERROR!!" ); return FALSE; }

	if( FAILED(m_pAMAnalogVideoDecoder->put_TVFormat( nStandard )) ) { SC_DEBUG( "CAnalogDeviceVideoGraph::SetStandard( IAMAnalogVideoDecoder::put_TVFormat() ) ERROR!!" ); return FALSE; }

	SC_DEBUG( "CAnalogDeviceVideoGraph::SetStandard( %08X )", nStandard );

	return TRUE;
}

BOOL CAnalogDeviceVideoGraph::GetLock( ULONG * pLock )
{
	// OLD METHOD
	//
//	if( NULL == pLock ) { SC_DEBUG( "CAnalogDeviceVideoGraph::GetLock( NULL ) ERROR!!" ); return FALSE; }
//
//	if( NULL == m_pAMAnalogVideoDecoder ) { SC_DEBUG( "CAnalogDeviceVideoGraph::GetLock( NULL ) ERROR!!" ); return FALSE; }
//
//	if( FAILED(m_pAMAnalogVideoDecoder->get_HorizontalLocked( (LONG *)(pLock) )) ) { SC_DEBUG( "CAnalogDeviceVideoGraph::GetLock( IQualProp::get_HorizontalLocked() ) ERROR!!" ); return FALSE; }

	// NEW METHOD
	//
	DWORD cbBytes = 0x00000000;

	if( NULL == pLock ) { SC_DEBUG( "CAnalogDeviceVideoGraph::GetSignalLock( NULL ) ERROR!!" ); return FALSE; }

	if( NULL == m_pKsPropertySet ) { SC_DEBUG( "CAnalogDeviceVideoGraph::GetSignalLock( NULL ) ERROR!!" ); return FALSE; }

	if( FAILED(m_pKsPropertySet->Get( m_sKsPropertySetGUID, 230 /*KSPROPERTY_CUSTOM_GET_ANALOG_VIDEO_LOCK_STATUS*/, NULL, 0, pLock, sizeof(ULONG), &cbBytes )) ) { SC_DEBUG( "CAnalogDeviceVideoGraph::GetSignalLock( IKsPropertySet::Get() ) ERROR!!" ); return FALSE; }

//	SC_DEBUG( "CAnalogDeviceVideoGraph::GetLock( %d )", *pLock );

	return TRUE;
}

BOOL CAnalogDeviceVideoGraph::GetCustomProperty( ULONG nProperty, ULONG * pValue )
{
	DWORD cbBytes = 0x00000000;

	if( NULL == pValue ) { SC_DEBUG( "CAnalogDeviceVideoGraph::GetCustomProperty( NULL ) ERROR!!" ); return FALSE; }

	if( NULL == m_pKsPropertySet ) { SC_DEBUG( "CAnalogDeviceVideoGraph::GetCustomProperty( NULL ) ERROR!!" ); return FALSE; }

	if( FAILED(m_pKsPropertySet->Get( m_sKsPropertySetGUID, nProperty, NULL, 0, pValue, sizeof(ULONG), &cbBytes )) ) { SC_DEBUG( "CAnalogDeviceVideoGraph::GetCustomProperty( IKsPropertySet::Get() ) ERROR!!" ); return FALSE; }

//	SC_DEBUG( "CAnalogDeviceVideoGraph::GetCustomProperty( %d  %d )", nProperty, *pValue );

	return TRUE;
}

BOOL CAnalogDeviceVideoGraph::SetCustomProperty( ULONG nProperty, ULONG nValue )
{
	UINT nSize = sizeof(ULONG);

	if( NULL == m_pKsPropertySet ) { SC_DEBUG( "CAnalogDeviceVideoGraph::SetCustomProperty( NULL ) ERROR!!" ); return FALSE; }

	if( FAILED(m_pKsPropertySet->Set( m_sKsPropertySetGUID, nProperty, NULL, 0, &nValue, nSize )) ) { SC_DEBUG( "CAnalogDeviceVideoGraph::SetCustomProperty( IKsPropertySet::Set() ) ERROR!!" ); return FALSE; }

	SC_DEBUG( "CAnalogDeviceVideoGraph::SetCustomProperty( %d  %d )", nProperty, nValue );

	return TRUE;
}

BOOL CAnalogDeviceVideoGraph::RefreshDisplayWindow() 
{
	CRect oOwnerWindowRect( 0, 0, 0, 0 );

	if( NULL == m_pVideoWindow ) { SC_DEBUG( "CAnalogDeviceVideoGraph::RefreshDisplayWindow( NULL x 2 ) ERROR!!" ); return FALSE; }

	OAHWND hWndOwner = NULL;

	if( FAILED(m_pVideoWindow->get_Owner( &hWndOwner )) ) { SC_DEBUG( "CAnalogDeviceVideoGraph::RefreshDisplayWindow( IVideoWindow::get_Owner() ) ERROR!!" ); return FALSE; }

	GetClientRect( (HWND)(hWndOwner), &oOwnerWindowRect );

	LONG cx = (ULONG)(oOwnerWindowRect.Width());

	LONG cy = (ULONG)(oOwnerWindowRect.Height());

	LONG x = 0;

	LONG y = 0;

	if( FAILED(m_pVideoWindow->SetWindowPosition( x, y, cx, cy )) ) { SC_DEBUG( "CAnalogDeviceVideoGraph::RefreshDisplayWindow( IVideoWindow::SetWindowPosition() ) ERROR!!" ); return FALSE; }

//	SC_DEBUG( "CAnalogDeviceVideoGraph::RefreshDisplayWindow( %d )", i );

	return TRUE;
}